#******************************************************************************************************
# file ser.s
#------------------------------------------------------------------------------------------------------
.data
buff:		.byte 0
#------------------------------------------------------------------------------------------------------
.text
#------------------------------------------------------------------------------------------------------
#Sottoprogramma tastiera: lettura di un carattere da tastiera e suo trasferimento in AL, 
#con: utilizzo del servizio UNIX 0x80 (parametri in RAX, RBX, RCX, RDX).
#------------------------------------------------------------------------------------------------------
tastiera:
		pushq 	%rbx
		pushq 	%rcx
		pushq 	%rdx
		movq  	$3, %rax			# primitiva read
		movq  	$0, %rbx   			# ingresso standard
		leaq 		buff(%rip), %rcx 		# indirizzo buffer di ingresso
		movq 		$1, %rdx    		# numero di byte da leggere
		int   	$0x80
		movb 		buff(%rip), %al
		popq 		%rdx
		popq 		%rcx
		popq 		%rbx
		ret	
#-------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------
#Sottoprogramma video: scrittura su video del carattere contenuto in BL, 
#con utilizzo del servizio UNIX 0x80 (parametri RAX, RBX, RCX, RDX)
#-------------------------------------------------------------------------------------------------------
video:
		pushq  	%rax
		pushq  	%rbx
		pushq  	%rcx
		pushq  	%rdx
		movb  	%bl, buff(%rip)		# il carattere contenuto in bl va nel buffer di uscita
		movq  	$4, %rax      		# primitiva write
		movq  	$1, %rbx      		# uscita standard
		leaq  	buff(%rip), %rcx 		# indirizzo buffer di uscita
		movq  	$1, %rdx      		# numero byte da scrivere
		int     	$0x80
		popq  	%rdx
		popq  	%rcx
		popq  	%rbx
		popq  	%rax
		ret	
#-------------------------------------------------------------------------------------------------------
#-------------------------------------------------------------------------------------------------------
# routine uscita
#-------------------------------------------------------------------------------------------------------

uscita:	movl	$0, %ebx				# restituisce 0
		movl	$1, %eax				# primitiva exit
		int		$0x80
#******************************************************************************************************

